(function(exports) {
exports.show_boards_by_type = function(types) { 
for (var board_number = 0; board_number < boards_count; board_number++)
{
//console.log("board_number "+board_number);
//console.log("types[board_number] "+types[board_number])
if (types[board_number] != null)
{
	var type = types[board_number].replace(/\u0000/g, '');

	if (board_number > 0)
	{
		var board_index = (0x4001 + (board_number - 1)*0x100).toString(16).toUpperCase()
		var board_div = $('<div>').addClass("board").attr({"id": `board_${board_number}`})
		var board_name = `${l100n.localize_string("module")} ${board_number}`
		var board_name_div = $('<div>').text(board_name).addClass('board_name')
		var empty_div = $('<div>').addClass('empty_space').addClass('board_name')
		//var eds_index = 0x4000 + (board_number - 1)*0x100;
		//var board_code = $('<div>').addClass("tag").attr({"index": `${eds_index.toString(16).toUpperCase()}:1`}).addClass('board_name')
		$.each(templates_commands.module_types(), function(index, item)
		{
			if (item.command == type)
			{
				board_code = item.name
			}
		})
		var board_name_table = $('<div>').append(board_name_div).append(empty_div).append(board_code).addClass('board_name')
		var board_head = $('<div>').append(board_name_table).addClass("accordion-header").attr({"status_index": `${board_index}:1`})
		var board_body = $('<div>').addClass("accordion-body")
	
		var board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": `${board_index}:1`}).hide()
		board_body.append(board_status);
		board_div.append(board_head);
		board_div.append(board_body);
		$("#io_settings").append(board_div);
	}

    if (type == get_set_value.board_types.deleted)
    {
		$(`#board_${board_number}`).hide();
    }
    else
    {
	var table = $('<table>').addClass('data_td');
	if (type == get_set_value.board_types.di || type == get_set_value.board_types.hdi)
	{
	    var count = 10;
		if (board_number == 0) count = 5;
		var start_subindex = 1

		var tabs_div = di_tab(board_number, start_subindex, count)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)	
	}
	else if ((type == get_set_value.board_types.em_h) || (type == get_set_value.board_types.em_l))
	{
		var main_description = {name: l100n.localize_string("C V PF"), blocks: [
			{
				header: l100n.localize_string("Current"),
				params: [
			    {name: "Ia, A ", index: 0x4064 + (board_number-1)*0x100, sub: 1},
			    {name: "Ib, A ", index: 0x4064 + (board_number-1)*0x100, sub: 2},
			    {name: "Ic, A ", index: 0x4064 + (board_number-1)*0x100, sub: 3},
			    {name: "Iavg, A ", index: 0x4064 + (board_number-1)*0x100, sub: 5},
			    {name: `Id, ${l100n.localize_string("mA")} `, index: 0x4064 + (board_number-1)*0x100, sub: 4}
			]},
			{
				header: l100n.localize_string("L2N Voltage"),
				params: [
			    {name: `Ua, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 1},
			    {name: `Ub, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 2},
			    {name: `Uc, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 3},
			    {name: `Uavg, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 4}
			]},
			{
				header: l100n.localize_string("L2L Voltage"),
				params: [
			    {name: `Uab, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 5},
			    {name: `Ubc, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 6},
			    {name: `Uca, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 7},
			    {name: `ULavg, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 8}
			]},
			{
				header: l100n.localize_string("Power Factor"),
				params: [
			    {name: "PFa ", index: 0x4066 + (board_number-1)*0x100, sub: 13},
			    {name: "PFb ", index: 0x4066 + (board_number-1)*0x100, sub: 14},
			    {name: "PFc ", index: 0x4066 + (board_number-1)*0x100, sub: 15},
			    {name: "PFavg ", index: 0x4066 + (board_number-1)*0x100, sub: 16}
			]}
		]}
	    var power = {name: l100n.localize_string("Power"), blocks: [
			{
				header: l100n.localize_string("Active"),
				params: [
			    {name: `Pa, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 1},
			    {name: `Pb, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 2},
			    {name: `Pc, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 3},
			    {name: `P, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 4}
			]},
			{
				header: l100n.localize_string("Reactive"),
				params: [
			    {name: `Qa, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 5},
			    {name: `Qb, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 6},
			    {name: `Qc, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 7},
			    {name: `Q, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 8}
			]},
			{
				header: l100n.localize_string("Apparent"),
				params: [
			    {name: `Sa, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 9},
			    {name: `Sb, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 10},
			    {name: `Sc, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 11},
			    {name: `S, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 12}
			]}
		]}
	    var energy = {name: l100n.localize_string("Energy"), blocks: [
			{
				header: l100n.localize_string("Active"),
				params: [
			    {name: `Wa+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 2},
			    {name: `Wb+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 3},
			    {name: `Wc+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 4},
			    {name: `W+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 5}
			]},
			{
				header: l100n.localize_string("Active"),
				params: [
			    {name: `Wa-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 6},
			    {name: `Wb-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 7},
			    {name: `Wc-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 8},
			    {name: `W-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 9}
			]},
			{
				header: l100n.localize_string("Reactive"),
				params: [
			    {name: `WQa+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 10},
			    {name: `WQb+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 11},
			    {name: `WQc+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 12},
			    {name: `WQ+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 13}
			]},
			{
				header: l100n.localize_string("Reactive"),
				params: [
			    {name: `WQa-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 14},
			    {name: `WQb-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 15},
			    {name: `WQc-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 16},
			    {name: `WQ-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 17}
			]},
			{
				header: l100n.localize_string("Apparent"),
				params: [
			    {name: `WSa, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 18},
			    {name: `WSb, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 19},
			    {name: `WSc, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 20},
			    {name: `WS, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 21}
			]}
		]}
	    var quality = {name: l100n.localize_string("Quality"), blocks: [
			{
				header: l100n.localize_string("Frequency"),
				params: [
			    {name: `F, ${l100n.localize_string("Hz")} `, index: 0x4068 + (board_number-1)*0x100, sub: 1}
			]},
			{
				header: l100n.localize_string("THD Current"),
				params: [
					{name: "THD Ia, % ", index: 0x4068 + (board_number-1)*0x100, sub: 6},
					{name: "THD Ib, % ", index: 0x4068 + (board_number-1)*0x100, sub: 7},
					{name: "THD Ic, % ", index: 0x4068 + (board_number-1)*0x100, sub: 8},
					{name: "THD Iavg, % ", index: 0x4068 + (board_number-1)*0x100, sub: 9}
			]},
			{
				header: l100n.localize_string("THD Voltage"),
				params: [
					{name: "THD Ua, % ", index: 0x4068 + (board_number-1)*0x100, sub: 2},
					{name: "THD Ub, % ", index: 0x4068 + (board_number-1)*0x100, sub: 3},
					{name: "THD Uc, % ", index: 0x4068 + (board_number-1)*0x100, sub: 4},
					{name: "THD Uavg, % ", index: 0x4068 + (board_number-1)*0x100, sub: 5}
			]},
			/*{params: [
			    {name: `U1, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 9},
			    {name: `U2, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 10},
			    {name: `U0, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 11},
				{name: "KU2, %: ", index: 0x4065 + (board_number-1)*0x100, sub: 12},
				{name: "KU0, %: ", index: 0x4065 + (board_number-1)*0x100, sub: 13}
			]}*/
		]}

		var ul = $('<ul>')
		ul.append($(`<li><a href="#em_main_description-tab${board_number}">${main_description.name}</a></li>`))
		ul.append($(`<li><a href="#em_power-tab${board_number}">${power.name}</a></li>`))
		ul.append($(`<li><a href="#em_energy-tab${board_number}">${energy.name}</a></li>`))
		ul.append($(`<li><a href="#em_quality-tab${board_number}">${quality.name}</a></li>`))	
		ul.append($(`<li><a href="#em_statistics-tab${board_number}">${l100n.localize_string("Statistics")}</a></li>`))
		ul.append($(`<li><a href="#em_db_settings-tab${board_number}">${l100n.localize_string("Deadband Settings")}</a></li>`))
		ul.append($(`<li><a href="#em_settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
		
		var em_settings_tbody = $(`<tbody id="em_settings-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_db_settings_tbody = $(`<tbody id="em_db_settings-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_main_description_tbody = $(`<tbody id="em_main_description-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_power_tbody = $(`<tbody id="em_power-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_energy_tbody = $(`<tbody id="em_energy-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_quality_tbody = $(`<tbody id="em_quality-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_statistics_tbody = $(`<tbody id="em_statistics-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')

		em_settings_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Scheme"))))
		em_settings_tbody.append(form_tag_tr(l100n.localize_string("Scheme"), 0x4060 + (board_number-1)*0x100, 1));
		em_settings_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Current ranges"))))
	    em_settings_tbody.append(form_tag_tr(l100n.localize_string("Current range"), 0x4060 + (board_number-1)*0x100, 2));
		em_settings_tbody.append(form_tag_tr(l100n.localize_string("Current range Lkg"), 0x4060 + (board_number-1)*0x100, 3));
		em_settings_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Transformation ratios"))))
	    em_settings_tbody.append(form_tag_divide_tr(l100n.localize_string("CTR"), 0x4060 + (board_number-1)*0x100, 4, 0x4060 + (board_number-1)*0x100, 5));
	    em_settings_tbody.append(form_tag_divide_tr(l100n.localize_string("CTR Lkg"), 0x4060 + (board_number-1)*0x100, 6, 0x4060 + (board_number-1)*0x100, 7));
	    em_settings_tbody.append(form_tag_divide_tr(l100n.localize_string("VTR"), 0x4060 + (board_number-1)*0x100, 8, 0x4060 + (board_number-1)*0x100, 9));

		var table_head = $('<tr>').addClass('table_header');
		table_head.append($('<td colspan="1">').text(""));
	    table_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband Reference")));
		table_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband, %")))
		em_db_settings_tbody.append(table_head)
	    em_db_settings_tbody.append(form_tag_tr2("Ia, Ib, Ic, A ", 0x4072 + (board_number-1)*0x100, 1, "", 0x406E + (board_number-1)*0x100, 1));
	    em_db_settings_tbody.append(form_tag_tr2("Id, A ", 0x4072 + (board_number-1)*0x100, 2, "", 0x406E + (board_number-1)*0x100, 2));
	    em_db_settings_tbody.append(form_tag_tr2(`U, ${l100n.localize_string("V")} `, 0x4073 + (board_number-1)*0x100, 1, "", 0x406F + (board_number-1)*0x100, 1));
		em_db_settings_tbody.append(form_tag_tr2(`P, ${l100n.localize_string("kW")}/ Q, ${l100n.localize_string("kvar")}/ S, ${l100n.localize_string("kVA")} `,
													 0x4074 + (board_number-1)*0x100, 1, "", 0x4070 + (board_number-1)*0x100, 1));
	    em_db_settings_tbody.append(form_tag_tr2("PF ", 0x4074 + (board_number-1)*0x100, 3, "", 0x4070 + (board_number-1)*0x100, 2));
	    em_db_settings_tbody.append(form_tag_tr2(`F, ${l100n.localize_string("Hz")} `, 0x4075 + (board_number-1)*0x100, 1, "", 0x4071 + (board_number-1)*0x100, 1));
	    em_db_settings_tbody.append(form_tag_tr2("THD I, % ", 0x4075 + (board_number-1)*0x100, 2, "", 0x4071 + (board_number-1)*0x100, 2));
		em_db_settings_tbody.append(form_tag_tr2("THD U, % ", 0x4075 + (board_number-1)*0x100, 2, "", 0x4071 + (board_number-1)*0x100, 3));
		em_db_settings_tbody.append(form_tag_tr2("K, % ", "", "", "", 0x4071 + (board_number-1)*0x100, 3));
		
		//create_block(em_main_description_tbody, main_description)
		em_main_description_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="5">').text(main_description.blocks[0].header)))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[0].params[0]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[0].params[1]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[0].params[2]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[0].params[3]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[0].params[4]))
		var main_description_head = $('<tr>').addClass('table_header');
	    main_description_head.append($('<td colspan="2">').text(main_description.blocks[1].header))
		main_description_head.append($('<td colspan="2">').text(main_description.blocks[2].header))
		em_main_description_tbody.append(main_description_head)
		em_main_description_tbody.append(form_tag_tr2_param(main_description.blocks[1].params[0], main_description.blocks[2].params[0]));
		em_main_description_tbody.append(form_tag_tr2_param(main_description.blocks[1].params[1], main_description.blocks[2].params[1]));
		em_main_description_tbody.append(form_tag_tr2_param(main_description.blocks[1].params[2], main_description.blocks[2].params[2]));
		em_main_description_tbody.append(form_tag_tr2_param(main_description.blocks[1].params[3], main_description.blocks[2].params[3]));
		em_main_description_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="5">').text(main_description.blocks[3].header)))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[3].params[0]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[3].params[1]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[3].params[2]))
		em_main_description_tbody.append(form_tag_tr_param(main_description.blocks[3].params[3]))
		
		create_block(em_power_tbody, power)
		
		//create_block(em_energy_tbody, energy)
		em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(energy.blocks[0].header)))
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[0].params[0], energy.blocks[1].params[0]));
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[0].params[1], energy.blocks[1].params[1]));
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[0].params[2], energy.blocks[1].params[2]));
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[0].params[3], energy.blocks[1].params[3]));
		em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(energy.blocks[2].header)))
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[2].params[0], energy.blocks[3].params[0]));
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[2].params[1], energy.blocks[3].params[1]));
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[2].params[2], energy.blocks[3].params[2]));
		em_energy_tbody.append(form_tag_tr2_param(energy.blocks[2].params[3], energy.blocks[3].params[3]));
		em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(energy.blocks[4].header)))
		em_energy_tbody.append(form_tag_tr_param(energy.blocks[4].params[0]))
		em_energy_tbody.append(form_tag_tr_param(energy.blocks[4].params[1]))
		em_energy_tbody.append(form_tag_tr_param(energy.blocks[4].params[2]))
		em_energy_tbody.append(form_tag_tr_param(energy.blocks[4].params[3]))
		em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(l100n.localize_string("Pulse Qty"))))
		var td1_pulsQty = $('<td>').text(`pulsQty, ${l100n.localize_string("kWh")}/${l100n.localize_string("kvarh")}/${l100n.localize_string("kVAh")} `);
		var td2_pulsQty = $('<td>').append($('<div>').addClass("io").addClass("tag").attr({"index": "4067:1"}));
		var tr_pulsQty = $('<tr class="can_hide">').append(td1_pulsQty).append(td2_pulsQty);
	    em_energy_tbody.append(tr_pulsQty)
		var em_energy_button = ($(`<input type="submit" value="${l100n.localize_string("COMMAND_CLEAR_ENERGY")}" id="COMMAND_CLEAR_ENERGY" board_number="${board_number}">`))
		em_energy_tbody.append(em_energy_button)

		create_block(em_quality_tbody, quality)

		em_statistics_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Symmetrical components"))))
		em_statistics_tbody.append(form_tag_tr_param({name: `U1, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 9}))
		em_statistics_tbody.append(form_tag_tr_param({name: `U2, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 10}))
		em_statistics_tbody.append(form_tag_tr_param({name: `U0, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 11}))
		em_statistics_tbody.append(form_tag_tr_param({name: "KU2, % ", index: 0x4065 + (board_number-1)*0x100, sub: 12}))
		em_statistics_tbody.append(form_tag_tr_param({name: "KU0, % ", index: 0x4065 + (board_number-1)*0x100, sub: 13}))
		em_statistics_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Operating Hours"))))
		em_statistics_tbody.append(form_tag_tr(`${l100n.localize_string("Operating Hours")} A`, 0x4069 + (board_number-1)*0x100, 1));
		em_statistics_tbody.append(form_tag_tr(`${l100n.localize_string("Operating Hours")} B`, 0x4069 + (board_number-1)*0x100, 2));
		em_statistics_tbody.append(form_tag_tr(`${l100n.localize_string("Operating Hours")} C`, 0x4069 + (board_number-1)*0x100, 3));
		em_statistics_tbody.append(form_tag_tr(l100n.localize_string("Total Operating Hours"), 0x4069 + (board_number-1)*0x100, 4));
		var em_statistics_button = ($(`<input type="submit" value="${l100n.localize_string("COMMAND_CLEAR_MTHRS")}" id="COMMAND_CLEAR_MTHRS" board_number="${board_number}">`))
		em_statistics_tbody.append(em_statistics_button)

		var table = $('<table>')
		table.append(em_main_description_tbody).append(em_power_tbody).append(em_energy_tbody).append(em_quality_tbody).append(em_settings_tbody).append(em_db_settings_tbody).append(em_statistics_tbody)
		var tabs_div = $('<div class="tab-class">').append(ul).append(table)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == get_set_value.board_types.hdo || type == get_set_value.board_types.ro)
	{
		var count = 10;
		if (type == get_set_value.board_types.ro)
		{
			count = 4;
		}
		if (board_number == 0) count = 5;
		var start_subindex = 1
		
		var tabs_div = do_tab(board_number, 1, count)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)	
	}
	else if ((type == get_set_value.board_types.ai))
	{
		var tabs_div = ai_tab(board_number, 1, 8, templates_commands.sensor_type_ai())
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == get_set_value.board_types.cti)
	{
		var tabs_div = ai_tab(board_number, 1, 8)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == get_set_value.board_types.ti)
	{
		var tabs_div = ai_tab(board_number, 1, 4, templates_commands.sensor_type_2())
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == get_set_value.board_types.rtd)
	{
		var tabs_div = ai_tab(board_number, 1, 4, templates_commands.sensor_type_rtd())
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == get_set_value.board_types.ao)
	{
	    var count = 2;
		var start_subindex = 1
		var ul = $('<ul>')
		ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("output state")}</a></li>`))	
		ul.append($(`<li><a href="#error_mode-tab${board_number}">${l100n.localize_string("Error mode")}</a></li>`))
		//ul.append($(`<li><a href="#error_value-tab${board_number}">${l100n.localize_string("Error value")}</a></li>`))
		ul.append($(`<li><a href="#scaling-tab${board_number}">${l100n.localize_string("Scaling")}</a></li>`))

		var value = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
		var scaling = $(`<tbody id="scaling-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
		var error_mode = $(`<tbody id="error_mode-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
		//var error_value = $(`<tbody id="error_value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
		
		value.append($('<tr>').addClass('table_header').append($('<td colspan="1">')).append($('<td colspan="1">').text(l100n.localize_string("value"))))
		var error_mode_header = $('<tr>').addClass('table_header')
		error_mode_header.append($('<td colspan="1">'))
		error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error value")))
		error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error mode")))
		error_mode.append(error_mode_header)

		var scaling_head = $('<tr>').addClass('table_header').append($('<td colspan="1">'));
	    scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Scaling")));
		scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Offset")))
		scaling.append(scaling_head)

		for (var eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
		{
			value.append(form_tag_tr(`${eds_subindex}`, 0x3F41 + board_number*0x100, eds_subindex));
			scaling.append(form_tag_tr2(`${eds_subindex}`, 0x3F43 + board_number*0x100, eds_subindex, "", 0x3F42 + board_number*0x100, eds_subindex));		
			var error_value_params = {name: `${eds_subindex}`, index: 0x3F45 + board_number*0x100, sub: eds_subindex}
			var error_mode_params = {name: "", index: 0x3F44 + board_number*0x100, sub: eds_subindex}
			error_mode.append(form_tag_tr2_param(error_value_params, error_mode_params));
		}

		var table = $('<table>')
		table.append(value).append(scaling).append(error_mode)
		var tabs_div = $('<div class="tab-class">').append(ul).append(table)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == get_set_value.board_types.f_lcd)
	{
		ul = $('<ul>')
		ul.append($('<li>').append($('<a>').prop('href',`#rtd_tab_${board_number}`).append("RTD")))
		var tbody_rtd = $('<tbody>').prop('id',`rtd_tab_${board_number}`).append(ai_tab(board_number, 5, 1, templates_commands.sensor_type_rtd()))
		ul.append($('<li>').append($('<a>').prop('href',`#ai_tab_${board_number}`).append("AI")))
		var tbody_ai = $('<tbody>').prop('id',`ai_tab_${board_number}`).append(ai_tab(board_number, 8, 1, templates_commands.sensor_type_ai()))
		ul.append($('<li>').append($('<a>').prop('href',`#cti_1_tab_${board_number}`).append("CTI-1")))
		var tbody_cti_1 = $('<tbody>').prop('id',`cti_1_tab_${board_number}`).append(ai_tab(board_number, 1, 1))
		ul.append($('<li>').append($('<a>').prop('href',`#cti_2_tab_${board_number}`).append("CTI-2")))
		var tbody_cti_2 = $('<tbody>').prop('id',`cti_2_tab_${board_number}`).append(ai_tab(board_number, 3, 1))
		ul.append($('<li>').append($('<a>').prop('href',`#di_tab_${board_number}`).append("DI")))
		var tbody_di = $('<tbody>').prop('id',`di_tab_${board_number}`).append(di_tab(board_number, 1, 4))
		ul.append($('<li>').append($('<a>').prop('href',`#do_tab_${board_number}`).append("DO")))
		var tbody_do = $('<tbody>').prop('id',`do_tab_${board_number}`).append(do_tab(board_number, 1, 2))

		var tab_table = $('<table>')
		tab_table.append(tbody_ai).append(tbody_cti_1).append(tbody_cti_2).append(tbody_rtd).append(tbody_di).append(tbody_do)

		var main_div = $('<div>').addClass('tab-class');
	    main_div.append(ul).append(tab_table)
	    $(`#board_${board_number}`).children('.accordion-body').append(main_div);
	}
	else if (type == get_set_value.board_types.f_io)
	{
		$(`#board_${board_number}`).addClass( "ui-state-disabled" )
	}
    }
}
else
{
    $(`#board_${board_number}`).hide();
}
}
}

function di_tab(board_number, start_subindex, count)
{
	var ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("input state")}</a></li>`))
	ul.append($(`<li><a href="#settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))

	var value_tab = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var settings_tab = $(`<tbody id="settings-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')

	var value_header = $('<tr>').addClass('table_header')
	value_header.append($('<td colspan="1">'))//.text(l100n.localize_string("Channel:")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("value")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("invert_polarity")))
	value_tab.append(value_header)

	var settings_header = $('<tr>').addClass('table_header')
	settings_header.append($('<td colspan="1">'))//.text(l100n.localize_string("Channel:")))
	settings_header.append($('<td colspan="1">').text(l100n.localize_string("invert_polarity")))
	settings_header.append($('<td colspan="1">').text(l100n.localize_string("Filter time, ms")))
	settings_tab.append(settings_header)

	for (var eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		var channel_number = eds_subindex - start_subindex + 1
		var value_params = {name: `${channel_number}`, index: 0x3F11 + board_number*0x100, sub: eds_subindex}
		var invert_params = {name: "", index: 0x3F12 + board_number*0x100, sub: eds_subindex, type: "ro"}
		value_tab.append(form_tag_tr2_param(value_params, invert_params));

		var invert2_params = {name: `${channel_number}`, index: 0x3F12 + board_number*0x100, sub: eds_subindex}
		var filter_time_params = {name: "", index: 0x3F13 + board_number*0x100, sub: eds_subindex}
		settings_tab.append(form_tag_tr2_param(invert2_params, filter_time_params));
	}

	var table = $('<table>').append(value_tab).append(settings_tab)
	var tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

function do_tab(board_number, start_subindex, count)
{
	var ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("output state")}</a></li>`))
	ul.append($(`<li><a href="#invert_polarity-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
	ul.append($(`<li><a href="#error_mode-tab${board_number}">${l100n.localize_string("Error mode")}</a></li>`))
	ul.append($(`<li><a href="#filter_mask-tab${board_number}">${l100n.localize_string("Filter mask")}</a></li>`))

	var value_tab = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var invert_polarity_tab = $(`<tbody id="invert_polarity-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var error_mode_tab = $(`<tbody id="error_mode-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var filter_mask_tab = $(`<tbody id="filter_mask-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	
	var value_header = $('<tr>').addClass('table_header')
	value_header.append($('<td colspan="1">'))//.text(l100n.localize_string("Channel:")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("value")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("invert_polarity")))
	value_tab.append(value_header)
	var error_mode_header = $('<tr>').addClass('table_header')
	error_mode_header.append($('<td colspan="1">'))
	error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error value")))
	error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error mode")))
	error_mode_tab.append(error_mode_header)
	invert_polarity_tab.append($('<tr>').addClass('table_header').append($('<td colspan="1">')).append($('<td colspan="1">').text(l100n.localize_string("invert_polarity"))))
	filter_mask_tab.append($('<tr>').addClass('table_header').append($('<td colspan="1">')).append($('<td colspan="1">').text(l100n.localize_string("Filter mask"))))

	for (var eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		var channel_number = eds_subindex - start_subindex + 1
		var value_params = {name: `${channel_number}`, index: 0x3F21 + board_number*0x100, sub: eds_subindex}
		var invert_params = {name: "", index: 0x3F22 + board_number*0x100, sub: eds_subindex, type: "ro"}
		value_tab.append(form_tag_tr2_param(value_params, invert_params));
		invert_polarity_tab.append(form_tag_tr(`${channel_number}`, 0x3F22 + board_number*0x100, eds_subindex));
		var error_value_params = {name: `${channel_number}`, index: 0x3F24 + board_number*0x100, sub: eds_subindex}
		var error_mode_params = {name: "", index: 0x3F23 + board_number*0x100, sub: eds_subindex}
		
		error_mode_tab.append(form_tag_tr2_param(error_value_params, error_mode_params));
		filter_mask_tab.append(form_tag_tr(`${channel_number}`, 0x3F25 + board_number*0x100, eds_subindex));
	}

	var table = $('<table>')
	table.append(value_tab).append(invert_polarity_tab).append(error_mode_tab).append(filter_mask_tab)
	var tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

function ai_tab(board_number, start_subindex, count, sensor_types=null)
{
	var ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("input state")}</a></li>`))
	ul.append($(`<li><a href="#deadband_settings-tab${board_number}">${l100n.localize_string("Deadband Settings")}</a></li>`))
	ul.append($(`<li><a href="#settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
	ul.append($(`<li><a href="#scaling-tab${board_number}">${l100n.localize_string("Scaling")}</a></li>`))
	
	var value = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var scaling = $(`<tbody id="scaling-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var settings = $(`<tbody id="settings-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var deadband_settings = $(`<tbody id="deadband_settings-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	
	var value_head = $('<tr>').addClass('table_header');
	value_head.append($('<td colspan="1">').text(""))
	value_head.append($('<td colspan="1">').text(l100n.localize_string("value")))
	value_head.append($('<td colspan="1">').text(l100n.localize_string("is_uA")))
	value.append(value_head)
	var deadband_head = $('<tr>').addClass('table_header');
	deadband_head.append($('<td colspan="1">').text(""));
	deadband_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband Reference")));
	deadband_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband, %")))
	deadband_settings.append(deadband_head)
	var scaling_head = $('<tr>').addClass('table_header').append($('<td colspan="1">').text(""));
	scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Scaling")));
	scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Offset")))
	scaling.append(scaling_head)
	var settings_head = $('<tr>').addClass('table_header').append($('<td colspan="1">').text(""));
	if (sensor_types != null)
	{
		settings_head.append($('<td colspan="1">').text(l100n.localize_string("Input Sensor")));
	}
	settings_head.append($('<td colspan="1">').text(l100n.localize_string("Filter time, ms")))
	settings.append(settings_head)

	for (var eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		var channel_number = eds_subindex - start_subindex + 1
		var eds_index = 0x3F39 + board_number*0x100
		configuration.add_template({"index": `${eds_index.toString(16).toUpperCase()}_${eds_subindex}`,"template": "combobox", "commands": templates_commands.sensor_type_ai()})

		var eds_index = 0x3F0F + board_number*0x100
		configuration.add_template({"index": `${eds_index.toString(16).toUpperCase()}_${eds_subindex}`,"template": "change_value", "commands": templates_commands.leakage_current_mode()})

		value.append(form_tag_tr2(`${channel_number}`, 0x3F31 + board_number*0x100, eds_subindex, "", 0x3F0F + board_number*0x100, eds_subindex));
		scaling.append(form_tag_tr2(`${channel_number}`, 0x3F32 + board_number*0x100, eds_subindex, "", 0x3F33 + board_number*0x100, eds_subindex));
		if (sensor_types != null)
		{
			settings.append(form_tag_tr2(`${channel_number}`, 0x3F39 + board_number*0x100, eds_subindex, "", 0x3F34 + board_number*0x100, eds_subindex));
		}
		else
		{
			settings.append(form_tag_tr(`${channel_number}`, 0x3F34 + board_number*0x100, eds_subindex));
		}
		deadband_settings.append(form_tag_tr2(`${channel_number}`, 0x3F3C + board_number*0x100, eds_subindex, "", 0x3F35 + board_number*0x100, eds_subindex));
	}

	var table = $('<table>')
	table.append(value).append(deadband_settings).append(settings).append(scaling)//.append(deadband)
	var tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

})(this.mcu_common = {});